var pts = ee.FeatureCollection(ee.List([
  ee.Feature(p1),ee.Feature(p2),ee.Feature(p3),
  ee.Feature(p4),ee.Feature(p5),ee.Feature(p6),
  ee.Feature(p7),ee.Feature(p8),ee.Feature(p9),
  ee.Feature(p10),ee.Feature(p11),ee.Feature(p12),
  ee.Feature(p13),ee.Feature(p14),ee.Feature(p15),
  ee.Feature(p16),ee.Feature(p17)]));

var result = ee.ImageCollection('MODIS/006/MYD11A1')
              .filter(ee.Filter.date('2009-11-01', '2010-11-01'))
              .select(["LST_Day_1km", "LST_Night_1km"])
              .map(function(image) {
                var time_start = image.get("system:time_start");
                image = image.multiply(0.02);
                return image.set("system:time_start", time_start);
              })
              .map(function(image) {
                var date = ee.Date(image.get("system:time_start")).format("yyyy-MM-dd");
                var fCol = image.reduceRegions({
                  collection: pts, 
                  reducer: ee.Reducer.mean(), 
                  scale: 1000,
                  tileScale: 16
                });
                fCol = fCol.map(function(f) {
                  f = ee.Feature(f);
                  return f.set("date", date);
                });
                return fCol;
              });
Export.table.toDrive({
  collection: result.flatten(), 
  description: "MYD11A1_point",
  selectors: [
    "system:index", "date", "LST_Day_1km", "LST_Night_1km"
  ]
});

